﻿var reports = {
    context: $(".v-reports"),
    datatable: null,
    treeview: null,
    canManagePermissions: $("#CanManagePermissions").val() == "True",
    initializeDataTable: function (folderId) {
        this.datatable = $(".h-reportsTable", this.context).a4datatable({
            advancedFilter: true,
            height: "full",
            ajaxAction: a4.getAction("GetReports", "Survey", "Reporting"),
            ajaxParams: { "parentFolderId": folderId },
            columns: [
                { "Name": "Id", "Title": resources.Id, "Data": "Id", "Visible": false, "Key": true },
                { "Name": "Name", "Title": resources.Name, "Data": "Name", "Class": "itemName", "HideInSelector": true },
                { "Name": "Description", "Title": resources.Description, "Data": "Description", },
                { "Name": "Type", "Title": resources.Type, "Data": "TypeEnum", "Type": "enum", "EnumType": "ReportType" },
                { "Name": "Folder", "Title": resources.Folder, "Data": "Folder" },
                { "Name": "CreationDate", "Title": resources.CreatedOn, "Data": "CreatedOn" },
                { "Name": "ModificationDate", "Title": resources.ModifiedOn, "Data": "ModifiedOn" },
                { "Name": "ModifiedBy", "Title": resources.ModifiedBy, "Data": "ModifiedBy" }
            ],
            stateKey: "SurveyReports",
            toolBarItems: [
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.CanBeDeleted; } }
            ],
            contextMenuItems: [
                { "Action": "edit", "Label": resources.ViewEdit, "DisplayCondition": function (data) { return data.CanBeModified; } },
                { "Action": "delete", "Label": resources.Delete, "DisplayCondition": function (data) { return data.CanBeDeleted; } },
                { "Divider": true },
                { "Action": "permissions", "Label": resources.EditPermissions, "DisplayCondition": function (data) { return reports.canManagePermissions && data.CanBeModified; } }
            ],
            contextMenuClick: function (event, data) {
                var row = data.row;
                var action = data.action;

                switch (action) {
                    case "edit":
                        window.location = a4.getAction("ViewEditReport", "Survey", "Reporting", { id: row.Id, folderid: row.FolderId });
                        break
                    case "delete":
                        reports.deleteReports([row.Id]);
                        break;
                    case "permissions":
                        modalDialog.showWindow(a4.getAction("ItemPermissionsEditor", "Users", "Settings", { id: row.Id, name: row.Name, objectType: "Report" }), 680, 600);
                        break;
                }
            },
            toolBarClick: function (event, data) {
                var rows = data.rows;
                var action = data.action;
                var ids = _.map(rows, function (row) { return row.Id });

                if (action == "delete") {
                    reports.deleteReports(ids);
                }
            },
            quickFilter: {
                "Items": [
                    { "Label": resources.Quotas, "AjaxParams": { "type": "Quotas" } },
                    { "Label": resources.CrossTab, "AjaxParams": { "type": "CrossTab" } },
                    { "Label": resources.OpenEnd, "AjaxParams": { "type": "OpenEnd" } }
                ]
            },
            localizableTexts: { "All": resources.AllSurveyReports, "Search": resources.SearchSurveyReports }
        });
    },
    initializeTreeView: function () {
        var actionButtons = [];

        if (reports.canManagePermissions) {
            actionButtons.push({ Action: "permissions", Label: resources.EditPermissions, Icon: "lock" });
        }

        actionButtons.push({ Action: "delete", Label: resources.Delete, Icon: "remove", DisplayCondition: function (data) { return data.ParentId > 0 && data.CanBeDeleted; } });
        actionButtons.push({ Action: "properties", Label: resources.Properties, Icon: "edit", DisplayCondition: function (data) { return data.ParentId > 0 && data.CanBeModified; } });

        this.treeview = $(".h-reportFolders", this.context).a4listview({
            ajaxAction: a4.getAction("GetReportFolders", "Survey", "Reporting"),
            stateKey: "SurveyReports",
            draw: function (event, data) {
                var folder = data.selectedNode;
                var folderId = folder ? (folder.Id || 0) : 0;

                if (reports.datatable) {
                    reports.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": folderId });
                    reports.datatable.a4datatable("refresh");
                }
                else {
                    reports.initializeDataTable(folderId);
                }

                if (folder) {
                    if (!folder.CanBeCreated)
                        $("#main-header .button", reports.context).hide();
                    else
                    {
                        $("#main-header .h-newReport[data-type='Quotas']", reports.context).toggle(folder.HasAccessToQuotas);
                        $("#main-header .h-newReport[data-type='CrossTab']", reports.context).toggle(folder.HasAccessToCrossTab);
                        $("#main-header .h-newReport[data-type='OpenEnd']", reports.context).toggle(folder.HasAccessToOpenEnd);
                    }
                }
            },
            highlightFirstNode: true,
            selectNode: function (event, data) {
                reports.datatable.a4datatable("option", "ajaxParams", { "parentFolderId": data.node.Id });
                reports.datatable.a4datatable("refresh", true);

                $("#main-header .h-newReportMenu", reports.context).toggle(data.node.CanBeCreated);
                $("#main-header .h-newReport[data-type='Quotas']", reports.context).toggle(data.node.HasAccessToQuotas);
                $("#main-header .h-newReport[data-type='CrossTab']", reports.context).toggle(data.node.HasAccessToCrossTab);
                $("#main-header .h-newReport[data-type='OpenEnd']", reports.context).toggle(data.node.HasAccessToOpenEnd);
            },
            actionButtons: actionButtons,
            actionButtonClick: function (event, data) {
                var action = data.action;
                var folderId = data.node.Id;

                switch (action) {
                    case "properties":
                        modalDialog.showWindow(a4.getAction("EditFolder", "Survey", "Reporting", { id: folderId }), 300, 500, { afterClose: function () { reports.treeview.a4listview("refresh") } });
                        break;
                    case "delete":
                        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
                            a4.callServerMethod(a4.getAction("DeleteFolder", "Survey", "Reporting"), { id: folderId },
                                function (result) {
                                    reports.treeview.a4listview("refresh");
                                });
                        }, 250, 500, true, { "count": 1 });
                        break;
                    case "permissions":
                        modalDialog.showWindow(a4.getAction("ItemPermissionsEditor", "Users", "Settings", { id: folderId, name: data.node.Name, objectType: "ReportFolder" }), 680, 600);
                        break;
                }
            },
            localizableTexts: { "Search": resources.SearchSurveyReportFolders }
        });
    },
    bindEvents: function () {
        $(".h-newReportMenu").on("click", "li.h-newReport", function () {
            var selectedFolder = $(".h-reportFolders").a4listview("getHighlightedNode");

            var selectedFolderId = selectedFolder ? selectedFolder.Id : $("#RootFolderId").val();

            var type = $(this).attr("data-type");

            window.location = a4.getAction("CreateReport", "Survey", "Reporting", { type: type.toLowerCase(), folderid: selectedFolderId });
        });

        $(".h-newReportMenu").on("click", "li.h-newFolder", function () {
            var selectedFolder = $(".h-reportFolders").a4listview("getHighlightedNode");

            var selectedFolderId = selectedFolder ? selectedFolder.Id : $("#RootFolderId").val();

            modalDialog.showWindow(a4.getAction("EditFolder", "Survey", "Reporting", { parentId: selectedFolderId }), 200, 500, { afterClose: function () { reports.treeview.a4listview("refresh") } });
        });
    },
    deleteReports: function (ids) {
        modalDialog.showConfirmDialog(confirmDeleteItemResources, function () {
            a4.callServerMethod(a4.getAction("DeleteReports", "Survey", "Reporting"), { ids: ids },
                function (result) {
                    reports.treeview.a4listview("refresh");
                });
        }, 250, 500, true, { "count": ids.length });
    }
}

$(document).ready(function () {
    if (reports.context.length > 0) {
        reports.initializeTreeView();
        reports.bindEvents();
    }
});